% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{associations}
\alias{associations}
\title{Query specific variants from specific GWAS}
\usage{
associations(
  variants,
  id,
  proxies = 1,
  r2 = 0.8,
  align_alleles = 1,
  palindromes = 1,
  maf_threshold = 0.3,
  opengwas_jwt = get_opengwas_jwt(),
  assocs_per_request = 64,
  max_ids_per_request = 10,
  ...
)
}
\arguments{
\item{variants}{Array of variants e.g. \code{c("rs234", "7:105561135-105563135")}}

\item{id}{Array of GWAS studies to query. See \code{\link{gwasinfo}} for available studies}

\item{proxies}{\code{0} or (default) \code{1} - indicating whether to look for proxies}

\item{r2}{Minimum proxy LD rsq value. Default=\code{0.8}}

\item{align_alleles}{Try to align tag alleles to target alleles (if \code{proxies = 1}).
\code{1} = yes (default), \code{0} = no}

\item{palindromes}{Allow palindromic SNPs (if \code{proxies = 1}). \code{1} = yes (default), \code{0} = no}

\item{maf_threshold}{MAF threshold to try to infer palindromic SNPs. Default = \code{0.3}.}

\item{opengwas_jwt}{Used to authenticate protected endpoints. Login to \url{https://api.opengwas.io} to obtain a jwt. Provide the jwt string here, or store in .Renviron under the keyname OPENGWAS_JWT.}

\item{assocs_per_request}{Number of associations to request per API call. Default=64 to avoid query being rejected by the API.}

\item{max_ids_per_request}{Maximum number of IDs to query per API call. Default=10 to avoid timeouts.}

\item{...}{Unused, for extensibility}
}
\value{
Dataframe
}
\description{
Every rsid is searched for against each requested GWAS id. To get a list of
available GWAS ids, or to find their meta data, use \code{\link{gwasinfo}}.
Can request LD proxies for instances when the requested rsid is not present
in a particular GWAS dataset. This currently only uses an LD reference panel
composed of Europeans in 1000 genomes version 3.
It is also restricted to biallelic single nucleotide polymorphisms (no indels),
with European MAF > 0.01.
}
