% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.freqplot.R
\name{categorical.freqplot}
\alias{categorical.freqplot}
\title{Produces frequency plots (normed to density plots to account for
different category sizes) for sanity check in categorical iGATE.}
\usage{
categorical.freqplot(df, target, ssv = NULL,
  outlier_removal_ssv = TRUE, savePlots = FALSE,
  image_directory = tempdir())
}
\arguments{
\item{df}{Data frame to be analysed.}

\item{target}{Categorical target varaible to be analysed.}

\item{ssv}{A vector of suspected sources of variation. These are the variables
in \code{df} which we believe might have an influence on the target variable and
will be tested. If no list of ssv is provided, the test will be performed
on all numeric variables.}

\item{outlier_removal_ssv}{Logical. Should outlier removal be performed for each ssv (default: \code{TRUE})?}

\item{savePlots}{Logical. If \code{FALSE} (the default) frequency plots will be output to the standard plotting
device. If \code{TRUE}, frequency plots will be saved to \code{image_directory} as png files.}

\item{image_directory}{Directory to which plots should be saved. This is only used if \code{savePlots = TRUE} and
defaults to the temporary directory of the current R session, i.e. \code{tempdir()}. To save plots to the current
working directory set \code{savePlots = TRUE} and \code{image_directory = getwd()}.}
}
\value{
The density plots of each category of \code{target} against each \code{ssv} are written as
.png file into the current working directory. Also, a data frame with the following
columns is output
\tabular{ll}{
\code{Causes} \tab The \code{ssv} that were analysed.\cr
\code{outliers_removed} \tab How many outliers (with respect to this \code{ssv})
have been removed before drawing the plot?\cr
\code{observations_retained} \tab After outlier removal was performed, how many observations
were left and used to fit the model?\cr
\code{frequency_plot} \tab Logical. Was plotting successful? No plot will be
produced if a ssv is constant.
}
}
\description{
This function takes a data frame, a categorical target variable and a list of ssv and
produces a density plot of each ssv and each category of the target variable. The output is written as
.png file into the current working directory. Also, summary statistics are provided.
The files can be saved into the current working directory. Consider changing the
working directory to a new empty folder before running if you want to save a copy of the plots.
}
\details{
Frequency plots for each \code{ssv} against  each category of the \code{target} are produced and
svaed to current working directory. Also a data frame with summary statistics is produced,
see \bold{Value} for details.
}
\examples{
categorical.freqplot(mtcars, target = "cyl")

}
