% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ihclust.R
\name{ihclust}
\alias{ihclust}
\title{Iterative Hierarchical Clustering (IHC)}
\usage{
ihclust(
  data,
  smooth = TRUE,
  cor_criteria = 0.75,
  max_iteration = 100,
  verbose = TRUE
)
}
\arguments{
\item{data}{a numeric matrix, each row representing a time-series
and each column representing a time point}

\item{smooth}{if smooth = 'TRUE', a smooth function is applied before clustering}

\item{cor_criteria}{pre-specified correlation criteria}

\item{max_iteration}{maximum number of iterations}

\item{verbose}{if verbose = 'TRUE', the result of a progress is printed}
}
\value{


Output from the function is a list of three items:
\itemize{
 \item Cluster_Label - the cluster label for each data point
 \item Num_Iterations - total number of iterations
 \item Unique_Clusters_in_Iteration - unique clusters in each iteration}
}
\description{
This function identifies inhomogeneous clusters using iterative hierarchical clustering (IHC) method.
}
\details{
ihclust

The IHC algorithm implements the three steps as outlined below.
First, the Initialization step clusters the data using hierarchical clustering.
Second, cluster centers are obtained as an average of all the data points in the cluster.
The Merging step considers each of the cluster centers (exemplars) as ‘new data point’,
and use the same procedure described in the Initialization step to merge the exemplars into a new set of clusters.
Third, the Pruning step streamlines the clusters and removes inconsistencies by
reassessing the cluster membership by each data point.
}
\examples{
# This is an example not using the permutation approach

opioid_data_noNA <- opioidData[complete.cases(opioidData), ] #remove NAs

mydata <- as.matrix(opioid_data_noNA[1:500,4:18])

testchange_results <- testchange(data=mydata,perm=FALSE,time=seq(1,15,1))

data_change <- testchange_results$sig.change

clustering_results <- ihclust(data=data_change, smooth = TRUE,

cor_criteria = 0.75, max_iteration = 100, verbose = TRUE)
}
\references{
1. Song, J., Carey, M., Zhu, H., Miao, H., Ram´ırez, J. C., & Wu, H. (2018). Identifying the dynamic gene regulatory network during latent HIV-1 reactivation using high-dimensional ordinary differential equations. International Journal of Computational Biology and Drug Design, 11,135-153. doi: 10.1504/IJCBDD.2018.10011910.
2. Wu, S., & Wu, H. (2013). More powerful significant testing for time course gene expression data using functional principal component analysis approaches. BMC Bioinformatics, 14:6.
3. Carey, M., Wu, S., Gan, G. & Wu, H. (2016). Correlation-based iterative clustering methods for time course data: The identification of temporal gene response modules for influenza infection in humans. Infectious Disease Modeling, 1, 28-39.
}
