% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_titles.R
\name{add_col_title}
\alias{add_col_title}
\alias{add_col_title,Iheatmap-method}
\title{add_col_title}
\usage{
\S4method{add_col_title}{Iheatmap}(
  p,
  title,
  textangle = 0,
  font = get_layout(p)$font,
  side = c("bottom", "top"),
  size = 0.1,
  buffer = 0.01,
  xname = current_xaxis(p),
  yname = NULL
)
}
\arguments{
\item{p}{iheatmap object}

\item{title}{title of axis}

\item{textangle}{angle of text}

\item{font}{list of plotly font attributes, see 
\url{https://plotly.com/javascript/reference/#layout-font}}

\item{side}{side of plot on which to add subplot}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{name for xaxis}

\item{yname}{name for yaxis}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add x axis title to plot
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_col_title("My x-axis")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_col_labels}}, \code{\link{iheatmap}}, 
\code{\link{add_row_title}}
}
\author{
Alicia Schep
}
