% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imcExperiment-class.R,
%   R/imcExperiment-methods.R
\docType{class}
\name{imcExperiment-class}
\alias{imcExperiment-class}
\alias{.imcExperiment}
\alias{getNetwork,imcExperiment-method}
\alias{getNetwork}
\alias{imcExperiment-method}
\alias{getNetwork<-,imcExperiment,data.frame-method}
\alias{getDistance,imcExperiment-method}
\alias{getDistance}
\alias{getDistance<-,imcExperiment,matrix-method}
\alias{getMorphology,imcExperiment-method}
\alias{getMorphology}
\alias{getMorphology<-,imcExperiment,matrix-method}
\alias{spatial}
\alias{getLabel,imcExperiment-method}
\alias{getLabel}
\title{a summarized experiment of IMC runs, dimensions of the spatial and intensity data are regulated.#'}
\usage{
getNetwork(object)

\S4method{getNetwork}{imcExperiment}(object)

\S4method{getNetwork}{imcExperiment,data.frame}(object) <- value

getDistance(object)

\S4method{getDistance}{imcExperiment}(object)

\S4method{getDistance}{imcExperiment,matrix}(object) <- value

getMorphology(object)

\S4method{getMorphology}{imcExperiment}(object)

\S4method{getMorphology}{imcExperiment,matrix}(object) <- value

getLabel(object)

\S4method{getLabel}{imcExperiment}(object)
}
\arguments{
\item{object}{imcExperiment}

\item{value}{matrix rows cells, columns are Area, etc.}
}
\value{
imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container

imcExperiment container
}
\description{
a summarized experiment of IMC runs, dimensions of the spatial and intensity data are regulated.#'

finds the network information.

assigns cell cluster assignment to the container. rows are cells and column is the cluster ID

finds the distance information.

distance matrix can be stored in the distance slot for pairwise distance

finds the morphology information.

morphological features can be stored (matrix) rows are cells and columns are Area, etc.

finds the label information.

unique cell labels can be assigned (vector)
}
\section{Slots}{

\describe{
\item{\code{coordinates}}{matrix class containing x,y coordinates}

\item{\code{cellIntensity}}{matrix class containing intensity}

\item{\code{neighborHood}}{matrix class containing x,y neighbor}

\item{\code{network}}{data frame class containing network}

\item{\code{distance}}{matrix class containing x,y distances}

\item{\code{morphology}}{matrix class containing morphology}

\item{\code{uniqueLabel}}{labels}
}}

\examples{
x<-imcExperiment(cellIntensity=matrix(1,nrow=10,ncol=10),
coordinates=matrix(1,nrow=10,ncol=2),
neighborHood=matrix(1,nrow=10,ncol=10),
network=data.frame(matrix(1,nrow=10,ncol=10)),
distance=matrix(1,nrow=10,ncol=10),
morphology=matrix(1,nrow=10,ncol=10),
uniqueLabel=paste0("A",seq_len(10)),
panel=letters[1:10],
ROIID=data.frame(ROIID=rep("A",10)))
data(imcdata)
getNetwork(imcdata)
data(imcdata)
getNetwork(imcdata)
data(imcdata)
x<-data.frame(ID=seq_len(ncol(imcdata)))
getNetwork(imcdata)<-x
data(imcdata)
getDistance(imcdata)
data(imcdata)
getDistance(imcdata)
data(imcdata)
newD<-matrix(1,nrow=ncol(imcdata),ncol=1)
getDistance(imcdata)<-newD
data(imcdata)
getMorphology(imcdata)
data(imcdata)
getMorphology(imcdata)
data(imcdata)
x<-matrix(1,nrow=ncol(imcdata),ncol=4)
getMorphology(imcdata)<-x
data(imcdata)
getLabel(imcdata)
data(imcdata)
getLabel(imcdata)
}
