% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weo_list_publications.R
\name{weo_list_publications}
\alias{weo_list_publications}
\title{List Available IMF WEO Publications}
\usage{
weo_list_publications(
  start_year = 2007,
  end_year = as.integer(format(Sys.Date(), "\%Y")),
  check_latest = FALSE
)
}
\arguments{
\item{start_year}{Minimum year to include. Defaults to 2007.}

\item{end_year}{Maximum year to include. Defaults to current year.}

\item{check_latest}{Logical indicating whether to check whether the latest
publication according to current date has been released. Defaults to FALSE.}
}
\value{
A data frame with columns:
\describe{
\item{year}{The year of the release}
\item{release}{The release name ("Spring" or "Fall")}
\item{month}{The month of release ("April" or "October")}
}
}
\description{
Returns a data frame of available WEO publications from 2007 onwards.
The IMF typically releases the WEO database twice per year:
\itemize{
\item Spring (April)
\item Fall (October)
}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
weo_list_publications(check_latest = TRUE)
}
\dontshow{\}) # examplesIf}
}
