% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_column_repair.R
\name{HLA_column_repair}
\alias{HLA_column_repair}
\title{HLA_column_repair}
\usage{
HLA_column_repair(data, format = "tidyverse", asterisk = FALSE)
}
\arguments{
\item{data}{A data frame}

\item{format}{Either "tidyverse" or "WHO".}

\item{asterisk}{Logical value to return column with an asterisk.}
}
\value{
A data frame object with column names renamed in the specified format.
}
\description{
This function will change column names that have the official
 HLA nomenclature (e.g. "HLA-A*" or "HLA-A") to a format more easily selected
 in tidyverse functions (e.g. "HLA_A"). The dash and asterisk are special
 characters in R, and makes selecting columns by name difficult. This function
 will also allow for easily changing back to WHO-compliant nomenclature
 (e.g. "HLA-A*").
}
\examples{
HLA_type <- data.frame(
  "HLA-A*" = c("01:01", "02:01"),
  "HLA-B*" = c("07:02", "08:01"),
  "HLA-C*" = c("03:04", "04:01"),
  stringsAsFactors = FALSE
)

HLA_column_repair(HLA_type, format = "tidyverse")

}
