% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowColVectors.R
\name{as.mRowVector}
\alias{as.mRowVector}
\alias{RowAndColumnVectors}
\alias{as.mColVector}
\title{Row and Column Vectors}
\usage{
as.mRowVector(x, USE.NAMES = TRUE)

as.mColVector(x, USE.NAMES = TRUE)
}
\arguments{
\item{x}{An object that can be passed to \code{\link[=array]{array()}}.}

\item{USE.NAMES}{If \code{TRUE} and \code{x} has only one non-singular dimension, its names are preserved.}
}
\value{
A row or column vector with the data from \code{x}.
}
\description{
These functions coerce an object to a 2-dimensional \code{\link{array}} in the shape of a
row or column vector, i.e. an array with dimensions \code{c(1,d)} or \code{c(d,1)}
respectively, where \code{d=length(x)}.
}
\examples{
x <- c(a=1, b=2, c=3)
as.mColVector(x)

y <- matrix(1:12, 3, 4)
as.mRowVector(y)

}
