% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walley1996.R
\name{dbetabinom}
\alias{dbetabinom}
\alias{pbetabinom}
\title{Beta-Binomial Distribution}
\usage{
dbetabinom(i, M, x, s, N, tA)

pbetabinom(M, x, s, N, y)
}
\arguments{
\item{i}{number of occurrences of event A in the M future trials}

\item{M}{number of future trials}

\item{x}{number of occurrence of event A in the N previous trials}

\item{s}{learning parameter}

\item{N}{total number of previous trials}

\item{tA}{prior probability of event A under the Dirichlet prior}

\item{y}{maximum number of occurrences of event A in the M future trials}
}
\value{
\code{dbetabinom} returns a scalar value of density and \code{pdetabinom} returns a list of scalars corresponding to the lower and upper probabilities of the distribution.
}
\description{
This function computes the predictive posterior density of the outcome of interest under the imprecise Dirichlet prior distribution. It follows a beta-binomial distribution.
}
\examples{
pbetabinom(M=6, x=1, s=1, N=6, y=0)
}
