% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_impute_AR1_Gaussian.R
\name{impute_rolling_AR1_Gaussian}
\alias{impute_rolling_AR1_Gaussian}
\title{Impute missing values of time series on a rolling window basis based on a Gaussian AR(1) model}
\usage{
impute_rolling_AR1_Gaussian(
  y,
  rolling_window = 252,
  random_walk = FALSE,
  zero_mean = FALSE,
  remove_outliers = FALSE,
  outlier_prob_th = 0.001,
  tol = 1e-10,
  maxiter = 100
)
}
\arguments{
\item{y}{Time series object coercible to either a numeric vector or numeric matrix 
(e.g., \code{zoo} or \code{xts}) with missing values denoted by \code{NA}.}

\item{rolling_window}{Rolling window length (default is \code{252}).}

\item{random_walk}{Logical value indicating if the time series is assumed to be a random walk so that \code{phi1 = 1} 
(default is \code{FALSE}).}

\item{zero_mean}{Logical value indicating if the time series is assumed zero-mean so that \code{phi0 = 0} 
(default is \code{FALSE}).}

\item{remove_outliers}{Logical value indicating whether to detect and remove outliers.}

\item{outlier_prob_th}{Threshold of probability of observation to declare an outlier (default is \code{1e-3}).}

\item{tol}{Positive number denoting the relative tolerance used as stopping criterion (default is \code{1e-8}).}

\item{maxiter}{Positive integer indicating the maximum number of iterations allowed (default is \code{100}).}
}
\value{
Same as \code{\link{impute_AR1_Gaussian}} for the case \code{n_samples = 1} 
        and \code{return_estimates = FALSE}.
}
\description{
Impute inner missing values (excluding leading and trailing ones) 
             of time series on a rolling window basis. This is a wrapper of the 
             function \code{\link{impute_AR1_Gaussian}}.
}
\examples{
library(imputeFin)
data(ts_AR1_Gaussian) 
y_missing <- ts_AR1_Gaussian$y_missing
y_imputed <- impute_rolling_AR1_Gaussian(y_missing)
plot_imputed(y_imputed)

}
\seealso{
\code{\link{plot_imputed}}, \code{\link{impute_AR1_Gaussian}}
}
\author{
Daniel P. Palomar
}
