% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute_REE.R
\name{impute_REE}
\alias{impute_REE}
\title{Impute Rare earth elements}
\usage{
impute_REE(data, prefix = NULL, suffix = NULL, rsquared = 0.95)
}
\arguments{
\item{data}{A dataframe resulting from 'model_ree()'}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}

\item{rsquared}{A numerical value between 0 and 1. Tolerance to mis-fitting models. set as 0.9 by default.}
}
\value{
A dataframe
}
\description{
Imputes missing REE after modelling. Expect the output of 'model_REE()'
function. Only missing values are replaced.
}
\details{
By default, exclude models with R-squared lower than 0.95. This limit is flexible and method dependent.
As guidelines, the Chondrite-Lattice mthod should consider R-squared > 0.95 for at least 3 points.
The Chondrite-Onuma method should consider R-squared >0.98 for at least 4 points.
}
\examples{

Ballard_et_al_Zircon \%>\%
dplyr::slice(1:100) \%>\%
model_REE(prefix = 'Zr', suffix = 'ppm') \%>\%
impute_REE(prefix = 'Zr', suffix = 'ppm')



}
