% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model_Wrappers.r
\name{modelChondrite_Onuma}
\alias{modelChondrite_Onuma}
\title{Model REE contents using the Chondrite-Onuma method of \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)}}
\usage{
modelChondrite_Onuma(
  dat,
  exclude = c("La", "Pr", "Ce", "Eu", "Y"),
  Calibrate = T,
  chondrite = PalmeOneill2014CI,
  prefix = NULL,
  suffix = NULL,
  Pr_correction_fact = 1/1,
  Nd_correction_fact = 1/1.026486418,
  Sm_correction_fact = 1/0.971111041,
  Gd_correction_fact = 1/0.95928241,
  Tb_correction_fact = 1/1.000985745,
  Dy_correction_fact = 1/1.030049321,
  Ho_correction_fact = 1/1.018711009,
  Er_correction_fact = 1/0.996610693,
  Tm_correction_fact = 1/1.053205463,
  Yb_correction_fact = 1/0.982656111,
  Lu_correction_fact = 1/0.952608321,
  Y_correction_fact = 1/0.665380561
)
}
\arguments{
\item{dat}{A data frame with REE data in ppm}

\item{exclude}{a string: vector including elements that should be omitted from modelling. La, Ce and Eu are the default. Ce and Eu should be always included}

\item{Calibrate}{Logical (T or F). If True, the model is calibrated using the correction factors. By default it is the reciprocal of the median REE from the work of Carrasco-Godoy and Campbell is used.}

\item{chondrite}{an option from: PalmeOneill2014CI, Oneill2014Mantle, McDonough1995CI}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}

\item{Pr_correction_fact}{a number: correction factor for overestimated Pr 1/0.918}

\item{Nd_correction_fact}{a number: correction factor for underestimated Nd 1/0.0.989}

\item{Sm_correction_fact}{a number: correction factor for overestimated Sm 1/1.022}

\item{Gd_correction_fact}{a number: correction factor for overestimated Gd 1/1.033}

\item{Tb_correction_fact}{a number: correction factor for overestimated Tb 1/1.050}

\item{Dy_correction_fact}{a number: correction factor for overestimated Dy 1/1.032}

\item{Ho_correction_fact}{a number: correction factor for Ho. 1 by default.}

\item{Er_correction_fact}{a number: correction factor for underestimated Er. 1/0.97 by default.}

\item{Tm_correction_fact}{a number: correction factor for Tm. 1 by default.}

\item{Yb_correction_fact}{a number: correction factor for underestimated Yb. 1/0.8785  by default.}

\item{Lu_correction_fact}{a number: correction factor for underestimated Lu. 1/0.8943 by default.}

\item{Y_correction_fact}{a number: correction factor for underestimated Y. 1/ 0.72 by default.}
}
\value{
a dataframe
}
\description{
This function apply the Chondrite-Onuma method which is a quadratic regression between the ionic radius of the REE and the logarithm of their chondrite normalized values. At least 3 non-linear points are required to use this method.
This method is based on the work of  \href{https://www.sciencedirect.com/science/article/abs/pii/S0012821X6880010X}{Onuma et al. (1968)} but using chondrite normalized values as noted by \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)}. Refer to \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)} for details.
}
\examples{
Ballard_et_al_Zircon \%>\%  modelChondrite_Onuma(prefix = 'Zr', suffix = 'ppm')
}
\seealso{
Other model REE: 
\code{\link{modelChondrite_lattice}()},
\code{\link{modelZhong}()},
\code{\link{model_REE}()}
}
\concept{model REE}
