#ifndef L0NORM_HPP
#define L0NORM_HPP

#include <RcppArmadillo.h>

namespace l0norm {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        return sum(wt != adjwt);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        size_t i;
        colvec tof = conv_to<colvec>::from(adjwt != wt);
        colvec df = adjwt - wt;
        double nz = sum(tof); // Counts the number of non zero elements
        for (i = 0; i < tof.size(); i++) {
            df[i] = tof[i] ? 1.0 / (nz * df[i]) : 0.0;
        }
        return df;
    }
}

#endif // L0NORM_HPP
