% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_confounded_data}
\alias{simulate_confounded_data}
\title{Simulation of confounded data with a continuous treatment}
\usage{
simulate_confounded_data(
  seed = 1,
  nobs = 1000,
  MX1 = -0.5,
  MX2 = 1,
  MX3 = 0.3,
  A_effect = TRUE
)
}
\arguments{
\item{seed}{random seed for reproducibility}

\item{nobs}{number of observations}

\item{MX1}{the mean of the first covariate. Defaults to -0.5, the value used in the simulations of Vegetabile, et al (2021).}

\item{MX2}{the mean of the second and fourth covariates. Defaults to 1, the value used in the simulations of Vegetabile, et al (2021).}

\item{MX3}{the probability that the fifth covariate (a binary covariate) is equal to 1. Defaults to 0.3, the value used in the
simulations of Vegetabile, et al (2021).}

\item{A_effect}{whether (\code{TRUE}) or not (\code{FALSE}) the treatment has a causal effect on the outcome. If \code{TRUE}, the
setting used is that of the main text of Vegetabile, et al (2021). If \code{FALSE}, the setting is that used in the Appendix of
Vegetabile, et al (2021).}
}
\value{
An list with elements:
\item{data}{A simulated dataset with \code{nobs} rows }
\item{true_adrf}{A function that inputs values of the treatment \code{A} and outputs the true ADRF, E(Y(A)), of the data-generating
mechanism used to generate \code{data}. }

A list with the following elements
\item{data}{a \code{data.frame} with the response (\code{Y}), treatment (\code{A}), confounders (\code{Z1} to \code{Z5}), and true average dose response function \code{truth}}
\item{true_adrf}{a function; true average dose response function}
\item{original_covariates}{original, untransformed covariates in the simulation setup. Do not use, as it makes the simulation setup significantly easier.}
}
\description{
Simulates confounded data with continuous treatment based on Vegetabile et al's simulation
}
\examples{

simdat <- simulate_confounded_data(seed = 999, nobs = 500)

str(simdat$data)

A <- simdat$data$A
y <- simdat$data$Y

trt_vec <- seq(min(simdat$data$A), max(simdat$data$A), length.out=500)
ylims <- range(c(simdat$data$Y, simdat$true_adrf(trt_vec)))
plot(x = simdat$data$A, y = simdat$data$Y, ylim = ylims)
lines(x = trt_vec, y = simdat$true_adrf(trt_vec), col = "blue", lwd=2)

## naive estimate of ADRF without weights
adrf_hat_unwtd <- weighted_kernel_est(A, y, rep(1, length(y)), trt_vec)$est
lines(x = trt_vec, y = adrf_hat_unwtd, col = "green", lwd=2)


}
\references{
Vegetabile, B. G., Griffin, B. A., Coffman, D. L., Cefalu, M., Robbins, M. W., and McCaffrey, D. F. (2021).
Nonparametric estimation of population average dose-response curves using entropy balancing weights for continuous exposures.
Health Services and Outcomes Research Methodology, 21(1), 69-110.
}
