% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress_incremental.R
\name{compress_incremental}
\alias{compress_incremental}
\title{Combine Results Saved by \code{save_objects} with \code{incremental=TRUE}}
\usage{
compress_incremental(
  folder,
  parameters_list,
  hash_includes_timestamp = FALSE,
  ignore_na = TRUE,
  alphabetical_order = TRUE,
  algo = "xxhash64",
  ignore_script_name = FALSE,
  remove_folder = TRUE
)
}
\arguments{
\item{folder}{Character string specifying the path to the directory where the temporary folder was saved (should be the same as supplied to \code{save_objects}.}

\item{parameters_list}{The named list of arguments used with \code{save_objects}.}

\item{hash_includes_timestamp}{Logical. If \code{TRUE}, the timestamp is included in the hash generation.}

\item{ignore_na}{Logical. If \code{TRUE}, \code{NA} values in \code{parameters_list} are ignored during hash generation.}

\item{alphabetical_order}{Logical. If \code{TRUE}, the names in \code{parameters_list} are sorted alphabetically before hash generation.}

\item{algo}{Character string specifying the hashing algorithm to use. Default is \code{"xxhash64"}. See \code{?digest}}

\item{ignore_script_name}{Logical. If \code{TRUE}, the script name is ignored during hash generation.}

\item{remove_folder}{Logical. If \code{TRUE}, the folder and the temporary results files will be discarded after the combined results are saved.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
This function is only intended to be used after \code{save_objects} with \code{incremental=TRUE}. In this case, \code{save_objects} with save results under temporary hashes in a folder with the hash corresponding the the parameters. \code{compress_incremental} then combines the results and saves them under the corresponding hash and deletes the old directory with the temporary results.
}
\details{
If the individual results can be put into a \code{data.frame} they will be, otherwise they will be stored as a list.
}
\examples{
## Save results incrementally
params <- list(a = "1", b = "2")

tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)
for (i in 1:10) {
  save_objects(tmp_dir, data.frame(idx = i, val = rnorm(1)), params, incremental = TRUE)
}

## See contents of tmp directory for incremental file
list.files(file.path(tmp_dir, generate_hash(params)))

## Compress results into a single file
compress_incremental(tmp_dir, params)
list.files(tmp_dir)

## Read in compressed file and view results
read_objects(tmp_dir, params)

## Cleanup
unlink(tmp_dir, recursive = TRUE)
}
\seealso{
\code{\link[=save_objects]{save_objects()}}
}
