% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagging.R
\name{start_tagging}
\alias{start_tagging}
\alias{cleanup}
\alias{close_tagging}
\title{Monitor result file usage and cleanup unused files}
\usage{
start_tagging(folder, tagging_file_name = "indexr_tagging.txt")

cleanup(
  folder,
  tagging_file_name = "indexr_tagging.txt",
  cutoff_date = NULL,
  request_confirmation = TRUE
)

close_tagging(folder, tagging_file_name = "indexr_tagging.txt")
}
\arguments{
\item{folder}{A character string specifying the path to the directory where the result files are saved and where the tagging file will be created.}

\item{tagging_file_name}{A character string for a txt file the tagging information is to be saved under.}

\item{cutoff_date}{A character string in "\%Y-\%m-\%d \%H:\%M:\%S" format used to specify that any tagged files before the date should also be removed.}

\item{request_confirmation}{Logical, if TRUE will request user input before proceeding to delete files.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Tagging is mainly helpful for removing unused results.
\code{start_tagging()} initializes the tagging process by creating a \code{txt} file in the results directory which will keep a record of which results are being read by \code{read_objects()}.
\code{cleanup()} removes any \code{.rds} files in the specified folder that are not listed in the tagging file.
\code{close_tagging()} deletes the tagging file, ending the tagging session.
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

## Save example objects
parameters_list1 <- list(example = "tagging1")
parameters_list2 <- list(example = "tagging2")
save_objects(folder = tmp_dir, results = 1, parameters_list = parameters_list1)
save_objects(folder = tmp_dir, results = 2, parameters_list = parameters_list2)

## See the files have been saved
list.files(tmp_dir)

## Start tagging
start_tagging(tmp_dir)

## Read back in one the first file, this causes this file to be tagged
res1 <- read_objects(folder = tmp_dir, parameters_list = parameters_list1)

## Remove untagged file without confirmation (that for parameters_list2)
cleanup(tmp_dir, request_confirmation = FALSE)

## See that one file was removed
list.files(tmp_dir)

## Close tagging (just removes tagging file)
close_tagging(tmp_dir)

## Cleanup
unlink(tmp_dir, recursive = TRUE)

}
