% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_tables.R
\name{get_metadata_operation_table}
\alias{get_metadata_operation_table}
\title{Get the operation for a given table}
\usage{
get_metadata_operation_table(
  idTable = NULL,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{idTable}{(int): id of the table. For further information about
ids click this \href{https://es-ine.github.io/ineapir/articles/identify_codes.html}{link}.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the operation according to the table specified in the function
}
\description{
Get the operation for a given table
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the operation of the table with identification code "50902"
df <- get_metadata_operation_table(idTable = 50902)
head(df)
\dontshow{\}) # examplesIf}
}
