\name{betacomp}
\alias{betacomp}

\title{
Beta Base on Complementarity of Ecological Communities
}
\description{
Estimate beta diversity based on the Bray-Curtis index  estiumates of 
complementarity (an assymetric meassures) betweb pairs of ecological 
communities.
}
\usage{
betacomp(M)
}

\arguments{
  \item{M}{
  A numeric matrix with at least two columns (sites) and r rows (species).
}
}

\value{
Return a list of matrixes of the complementarities between pairs of 
communities and the beta diversity between them.
}

\references{
Aguirre, A., Guevara, R., García, M. and López, J.C. (2010), Fate of epiphytes 
on phorophytes with different architectural characteristics along the 
perturbation gradient of Sabal mexicana forests in Veracruz, Mexico. 
Journal of Vegetation Science, 21: 6-15.
https://doi.org/10.1111/j.1654-1103.2009.01131.x
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
library(vegan)
data(dune)
betacomp(t(dune[1:4,]))
}
