% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_make_grid.R
\name{make_grid}
\alias{make_grid}
\title{Makes a grid set of coordinates}
\usage{
make_grid(lat1, lat2, lon1, lon2, space_lat = 0.07, space_lon = 0.07)
}
\arguments{
\item{lat1}{First corner (latitud). Must be numeric.}

\item{lat2}{Second corner (latitud). Must be numeric.}

\item{lon1}{First corner (longitud). Must be numeric.}

\item{lon2}{Second corner (longitud). Must be numeric.}

\item{space_lat}{Space between latitud coordinates defaults to 0.07 degrees}

\item{space_lon}{Space between longitud coordinates defaults to 0.07 degrees}
}
\value{
Data.frame
}
\description{
Returns a set of coordinates that intertwine to create an area larger than 5 kilometers. 
Suggestion by Arturo Cardenas \url{https://github.com/arturocm}.
}
\examples{

latitud1 <- 25.66919
latitud2 <- 25.169194
longitud1 <- -100.30990
longitud2 <- -101.20102
setofcoords <- make_grid(latitud1, latitud2, longitud1, longitud2)
}
\seealso{
denue_grid
}
\author{
Arturo Cardenas
}
