\name{plot.inequality_curves}
\alias{plot.inequality_curves}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot inequality curves
}
\description{
Method of the generic \code{\link{plot}} for objects generated by the function \code{\link{inequalityCurves}}.
}
\usage{
\method{plot}{inequality_curves}(
  x,
  pch = 16,
  from = 0,
  to = 1,
  xlim = NULL,
  ylim = NULL,
  xaxs = "i",
  yaxs = "i",
  xlab = "p",
  ylab = NULL,
  main = attributes(x)$index,
  sub = paste0(
    "grp: ",
    paste(attributes(x)$groups, collapse = ", "),
    "; src: ",
    paste(attributes(x)$sources, collapse = ", ")
  ),
  ...
)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
% guardare plot.default
  \item{x}{
Object of class \code{"decomposition"}.
}

  \item{pch}{
A vector of plotting characters or symbols: see \code{\link{points}}.
}
  \item{from, to}{
The range over which the function will be plotted.
}
%  \item{to}{
%Abscissas upper bound.
%}
  \item{xlim}{
The x limits (x1, x2) of the plot. The default value, \code{NULL}, indicates that the range of the function should be used.
}
  \item{ylim}{
the y limits of the plot.
}
  \item{xaxs}{
The style of axis interval calculation to be used for the x-axis. See \code{\link{par}} for details.
}
  \item{yaxs}{
The style of axis interval calculation to be used for the y-axis. See \code{xaxs} above.
}
  \item{xlab}{
a title for the x axis: see \code{\link{title}}.
}
  \item{ylab}{
a title for the y axis: see \code{\link{title}}.
}
  \item{main}{
an overall title for the plot: see \code{\link{title}}.
}
  \item{sub}{
a sub title for the plot: see \code{\link{title}}.
}

\item{\dots}{
Arguments to be passed to methods, such as \code{\link{graphical parameters}} (see \code{\link{par}}). Many methods will accept the following arguments:
}
}

\details{
This method is a convenience wrapper for plotting inequality curves. Default values of the \code{plot} are modified in order to plot inequality curves in the unitary square. Moreover, the default value of the argument \code{sub} shows in the plot if the curve represents the whole inequality or a contribution.
}

\value{
  The same output of the function \code{\link{plot.stepfun}}, a list with two components:
  \item{t}{abscissa (x) values, including the two outermost ones.}
  \item{y}{y values \sQuote{in between} the \code{t[]}.}
}
\references{
Zenga M. M.(2007). Inequality Curve and Inequality Index based on the Ratios between llower and upper Means . Statistica and Applicazioni, V (1), 3-27.

Zenga M. (2015) Joint decomposition by subpopulations and sources of the point and synthetic Zenga(2007) Index I(Y). Statistica and Applicazioni, XIII (2), pp.163-195.

Zenga M., Valli I. (2017). Joint decomposition by Subpopulations and Sources of the Point and Synthetic Bonferroni Inequality Measures. Statistics and Applications, XV (2), pp. 83-120.

Zenga M., Valli I. (2018). Joint decomposition by Subpopulations and Sources of the Point and Synthetic Gini Indexes. Statistics and Applications, XVI (1).
}
\author{
Alberto Arcagni, Igor Valli
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{plot}}, \code{\link{graphical parameters}}, \code{\link{par}}, \code{\link{plot.stepfun}}, \code{\link{inequalityCurves}}
}
\examples{
G <- c(1, 2, 3, 1, 2, 3, 1, 1, 2, 3, 3, 3) # vector denoting group membership
X1 <- c(0, 0, 0, 500, 700, 300, 750, 1000, 500, 500, 500, 1000) # vector of the first source
X2 <- c(0, 0, 0, 500, 300, 700, 750, 500, 700, 700, 1000,600) # vector of the second source
data <- data.frame(G, X1, X2) # no sample weights are considered
x <- dataProcessing( # data preparation
  units = data[, c('X1', 'X2')],
  groups = data[, 'G'],
)
decomposition <- zenga(x)
ic <- inequalityCurves(decomposition)
contrib1 <- inequalityCurves(decomposition, l = 1)
contrib12 <- inequalityCurves(decomposition, l = 1:2)

plot(ic)
plot(contrib1, add = TRUE)
plot(contrib12, add = TRUE)
text(0.1, 1/6+0:2/3, labels = c("G1", "G2", "G3"))
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
