% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_network.R
\name{single_network}
\alias{single_network}
\title{Construct network for single target gene}
\usage{
single_network(
  matrix,
  regulators,
  target,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  r_squared_threshold = 0,
  n_folds = 5,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{matrix}{An expression matrix.}

\item{regulators}{The regulator genes for which to infer the regulatory network.}

\item{target}{The target gene.}

\item{cross_validation}{Whether to use cross-validation.
Default is \code{FALSE}.}

\item{seed}{The random seed for cross-validation.
Default is \code{1}.}

\item{penalty}{The type of regularization, default is \code{"L0"}.
This can take either one of the following choices: \code{"L0"}, \code{"L0L1"}, and \code{"L0L2"}.
For high-dimensional and sparse data, \code{"L0L2"} is more effective.}

\item{r_squared_threshold}{Threshold of \eqn{R^2} coefficient.
Default is \code{0}.}

\item{n_folds}{The number of folds for cross-validation.
Default is \code{5}.}

\item{verbose}{Whether to print progress messages.
Default is \code{TRUE}.}

\item{...}{Parameters for other methods.}
}
\value{
A data frame of the single target gene network.
The data frame has three columns: regulator, target, and weight.
}
\description{
Construct network for single target gene
}
\examples{
data(example_matrix)
head(
  single_network(
    example_matrix,
    regulators = colnames(example_matrix),
    target = "g1"
  )
)
head(
  single_network(
    example_matrix,
    regulators = colnames(example_matrix),
    target = "g1",
    cross_validation = TRUE
  )
)

single_network(
  example_matrix,
  regulators = c("g1", "g2", "g3"),
  target = "g1"
)
single_network(
  example_matrix,
  regulators = c("g1", "g2"),
  target = "g1"
)
}
