% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{t_test}
\alias{t_test}
\title{Tidy t-test}
\usage{
t_test(
  x,
  formula,
  response = NULL,
  explanatory = NULL,
  order = NULL,
  alternative = "two-sided",
  mu = 0,
  conf_int = TRUE,
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{formula}{A formula with the response variable on the left and the
explanatory on the right. Alternatively, a \code{response} and \code{explanatory}
argument can be supplied.}

\item{response}{The variable name in \code{x} that will serve as the response.
This is an alternative to using the \code{formula} argument.}

\item{explanatory}{The variable name in \code{x} that will serve as the
explanatory variable. This is an alternative to using the formula argument.}

\item{order}{A string vector of specifying the order in which the levels of
the explanatory variable should be ordered for subtraction, where \code{order = c("first", "second")} means \code{("first" - "second")}.}

\item{alternative}{Character string giving the direction of the alternative
hypothesis. Options are \code{"two-sided"} (default), \code{"greater"}, or \code{"less"}.}

\item{mu}{A numeric value giving the hypothesized null mean value for a one
sample test and the hypothesized difference for a two sample test.}

\item{conf_int}{A logical value for whether to include the confidence
interval or not. \code{TRUE} by default.}

\item{conf_level}{A numeric value between 0 and 1. Default value is 0.95.}

\item{...}{For passing in other arguments to \link[stats:t.test]{t.test()}.}
}
\description{
A tidier version of \link[stats:t.test]{t.test()} for two sample tests.
}
\examples{
library(tidyr)

# t test for number of hours worked per week
# by college degree status
gss |>
   tidyr::drop_na(college) |>
   t_test(formula = hours ~ college,
      order = c("degree", "no degree"),
      alternative = "two-sided")

# see vignette("infer") for more explanation of the
# intuition behind the infer package, and vignette("t_test")
# for more examples of t-tests using infer

}
\seealso{
Other wrapper functions: 
\code{\link{chisq_stat}()},
\code{\link{chisq_test}()},
\code{\link{observe}()},
\code{\link{prop_test}()},
\code{\link{t_stat}()}
}
\concept{wrapper functions}
