% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-chisq-assoc-test.R
\name{ifr_chisq_assoc_test}
\alias{ifr_chisq_assoc_test}
\alias{infer_chisq_assoc_test}
\title{Chi Square Test of Association}
\usage{
ifr_chisq_assoc_test(data, x, y)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{factor; column in \code{data}}

\item{y}{factor; column in \code{data}}
}
\value{
\code{ifr_chisq_assoc_test} returns an object of class
\code{"ifr_chisq_assoc_test"}. An object of class
\code{"ifr_chisq_assoc_test"} is a list containing the
following components:

\item{chisquare}{chi square}
\item{chisquare_lr}{likelihood ratio chi square}
\item{chisquare_mantel_haenszel}{mantel haenszel chi square}
\item{chisquare_adjusted}{continuity adjusted chi square}
\item{contingency_coefficient}{contingency coefficient}
\item{cramers_v}{cramer's v}
\item{df}{degrees of freedom}
\item{ds}{product of dimensions of the table of \code{x} and \code{y}}
\item{phi_coefficient}{phi coefficient}
\item{pval_chisquare}{p-value of chi square}
\item{pval_chisquare_adjusted}{p-value of continuity adjusted chi square}
\item{pval_chisquare_lr}{p-value of likelihood ratio chi square}
\item{pval_chisquare_mantel_haenszel}{p-value of mantel haenszel chi square}
}
\description{
Chi Square test of association to examine if there is a
relationship between two categorical variables.
}
\section{Deprecated Function}{

\code{infer_chisq_assoc_test()} has been deprecated. Instead use
\code{ifr_chisq_assoc_test()}.
}

\examples{
ifr_chisq_assoc_test(hsb, female, schtyp)

ifr_chisq_assoc_test(hsb, female, ses)

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}
