% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_write.R
\name{influx_write}
\alias{influx_write}
\alias{influx_write.xts}
\alias{influx_write.data.frame}
\title{Write an xts or data.frame object to an InfluxDB server}
\usage{
influx_write(x, con, db, measurement, rp = NULL, precision = c("s", "ns",
  "u", "ms", "m", "h"), consistency = c(NULL, "one", "quroum", "all", "any"),
  max_points = 5000, use_integers = FALSE, ...)

\method{influx_write}{xts}(x, con, db, measurement, rp = NULL,
  precision = c("s", "ns", "u", "ms", "m", "h"), consistency = c(NULL,
  "one", "quroum", "all", "any"), max_points = 5000, use_integers = FALSE,
  ...)

\method{influx_write}{data.frame}(x, con, db, measurement = NULL, rp = NULL,
  precision = c("s", "ns", "u", "ms", "m", "h"), consistency = c(NULL,
  "one", "quroum", "all", "any"), max_points = 5000, use_integers = FALSE,
  time_col = NULL, tag_cols = NULL, measurement_col = NULL, ...)
}
\arguments{
\item{x}{The object to write to an InfluxDB server (either of class \code{xts} or \code{data.frame}).}

\item{con}{An \code{influx_connection} object (s. \code{\link{influx_connection}}).}

\item{db}{Sets the target database for the query.}

\item{measurement}{Sets the name of the measurement (data.frame has data to write
to one measurement only). If both arguments \code{measurement} and \code{measurement_col}
are given, \code{measurement} gets overridden.}

\item{rp}{Sets the target retention policy for the write. If not present the
default retention policy is used.}

\item{precision}{Sets the precision of the supplied Unix time values
("s", "ns", "u", "ms", "m", "h"). If not present timestamps are assumed to be
in seconds.}

\item{consistency}{Set the number of nodes that must confirm the write.
If the requirement is not met the return value will be partial write
if some points in the batch fail, or write failure if all points in the batch
fail.}

\item{max_points}{Defines the maximum points per batch (defaults to 5000).}

\item{use_integers}{Should integers (instead of doubles) be written if present?}

\item{...}{Arguments to be passed to methods.}

\item{time_col}{A character scalar naming the time index column.}

\item{tag_cols}{A character vector naming tag columns.}

\item{measurement_col}{A character scalar naming the measurement column (data.frame
has data to write to multiple measurements). Overrides \code{measurement} argument.}
}
\value{
A list of server responses.
}
\description{
This function writes either an \code{xts} object or a \code{data.frame} to an InfluxDB server.
In case of an xts object, columnnames of the \code{xts} object are used as InfluxDB's field keys,
\code{xts}'s coredata represent field values. Attributes are preserved and written
as tag keys and values, respectively.

In case of a \code{data.frame}, columns may represent times and both tag and field values.
Columnnames of the \code{data.frame} object are used as InfluxDB's tag and field keys.
Times and tags are optional. Use parameter \code{time_col} and \code{tag_col} to define
the interpretation. By specifiying one of the arguments \code{measurement} or \code{measurement_col},
a data.frame may contain data from one measurement or multiple measurements, respectively.
}
\references{
\url{https://docs.influxdata.com/influxdb/}
}
\seealso{
\code{\link[xts]{xts}}, \code{\link[influxdbr]{influx_connection}}
}
