% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{iinla}
\alias{iinla}
\title{Iterated INLA}
\usage{
iinla(model, lhoods, inputs = NULL, initial = NULL, options)
}
\arguments{
\item{model}{A \link{bru_model} object}

\item{lhoods}{A list of likelihood objects from \code{\link[=bru_obs]{bru_obs()}}}

\item{inputs}{Optional pre-computed  list of per-likelihood component
evaluations, from \code{\link[=bru_input.bru_obs_list]{bru_input.bru_obs_list()}}.}

\item{initial}{A previous \code{bru} result or a list of named latent variable
initial states (missing elements are set to zero), to be used as starting
point, or \code{NULL}. If non-null, overrides \code{options$bru_initial}}

\item{options}{A \code{bru_options} object.}
}
\value{
An \code{iinla} object that inherits from \code{INLA::inla}, with an
added field \code{bru_iinla} with elements
\describe{
\item{log}{The diagnostic log messages produced by the run}
\item{states}{The list of linearisation points, one for each inla run}
\item{inla_stack}{The \code{inla.stack} object from the final inla run}
\item{track}{A list of convergence tracking vectors}
}
If an inla run is aborted by an error, the returned object also contains
an element \code{error} with the error object.
}
\description{
This is an internal wrapper for iterated runs of \code{INLA::inla}.
For nonlinear models, a linearisation is done with
\code{bru_compute_linearisation}, with a line search method between each
iteration. The \code{INLA::inla.stack} information is setup by \code{\link[=bru_make_stack]{bru_make_stack()}}.
}
\keyword{internal}
