% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-functional-test.R
\name{two_sample_functional_test}
\alias{two_sample_functional_test}
\title{Two-sample test for functional representations of persistence homology data}
\usage{
two_sample_functional_test(
  x,
  y,
  dimension = 0L,
  scale_size = 100L,
  representation = c("betti", "euler", "life", "silhouette", "entropy"),
  mu = 0,
  order = 2L,
  nknots = scale_size,
  B = 1000L,
  paired = FALSE
)
}
\arguments{
\item{x}{An object of class \code{persistence_set} typically produced by
\code{\link[phutil:persistence-set]{phutil::as_persistence_set()}} specifying the first sample.}

\item{y}{An object of class \code{persistence_set} typically produced by
\code{\link[phutil:persistence-set]{phutil::as_persistence_set()}} specifying the second sample.}

\item{dimension}{An integer value specifying the homology dimension to use.
Defaults to \code{0L}, which corresponds to the 0-dimensional homology.}

\item{scale_size}{An integer value specifying the number of scale values to
use for the functional representation. Defaults to \code{100L}.}

\item{representation}{A string specifying the functional representation to
use. Choices are \code{"betti"}, \code{"euler"}, \code{"life"}, \code{"silhouette"}, and
\code{"entropy"}. Defaults to \code{"betti"}.}

\item{mu}{
The difference between the first functional population and the second functional population under the null hypothesis. Either a constant (in this case, a constant function is used) or a \code{J}-dimensional vector containing the evaluations on the same grid which \code{data} are evaluated. The default is \code{mu=0}.
}

\item{order}{
Order of the B-spline basis expansion. The default is \code{order=2}.
}

\item{nknots}{An integer value specifying the number of knots to use for the
B-spline representation. Defaults to \code{scale_size}.}

\item{B}{An integer value specifying the number of permutations to use for
the permutation hypothesis test. Defaults to \code{1000L}.}

\item{paired}{
A logical indicating whether the test is paired. The default is \code{FALSE}.
}
}
\value{
A length-4 list containing the following objects:
\itemize{
\item \code{xfd}: A numeric matrix of shape \eqn{n_1 \times p} storing the
representation of the first sample on a uniform grid.
\item \code{yfd}: A numeric matrix of shape \eqn{n_2 \times p} storing the
representation of the second sample on a uniform grid.
\item \code{scale_seq}: A numeric vector of shape \eqn{p} storing the scale sequence
used for the functional representation.
\item \code{iwt}: An object of class \code{ITP2} which is a list containing at least the
following components:
\itemize{
\item \code{basis}: A string indicating the basis used for the first phase of the algorithm. In this case, equals to \code{"B-spline"}.
\item \code{test}: A string indicating the type of test performed. In this case, equals to \code{"2pop"}.
\item \code{mu}: The difference between the mean of the first and second populations under the null hypothesis (as entered by the user).
\item \code{paired}: A boolean value indicating whether the two samples are paired or not (as entered by the user).
\item \code{coeff}: A numeric matrix of shape \eqn{n \times p} of the \eqn{p} coefficients of the B-spline basis expansion, with \eqn{n = n_1 + n_2}. Rows are associated to units and columns to the basis index. The first \eqn{n_1} rows report the coefficients of the first population units and the following \eqn{n_2} rows report the coefficients of the second population units.
\item \code{pval}: A numeric vector of shape \eqn{p} storing the \strong{uncorrected} p-values for each coefficient of the B-spline basis expansion.
\item \code{pval.matrix}: A numeric matrix of shape \eqn{p \times p} of the p-values of the multivariate tests. The element \eqn{(i, j)} of the \code{pval.matrix} matrix contains the p-value of the joint NPC test of the components \eqn{(j, j+1, \dots, j+(p-i))}.
\item \code{corrected.pval}: A numeric vector of shape \eqn{p} storing the \strong{corrected} p-values for each coefficient of the B-spline basis expansion.
\item \code{labels}: A character vector of shape \eqn{n} storing the membership of each unit to the first or second population.
\item \code{data.eval}: A numeric matrix of shape \eqn{n \times p} storing the evaluation of the functional data on a uniform grid.
\item \code{heatmap.matrix}: A numeric matrix storing the p-values. Used only for plots.
}
}
}
\description{
This function performs a two-sample test for persistence homology data using
the theory of permutation hypothesis testing to test the null hypothesis that
the two samples come from the same distribution. The input data must be objects
of class \code{persistence_set} typically produced by \code{\link[phutil:persistence-set]{phutil::as_persistence_set()}}.
}
\examples{
tref1 <- trefoils1[1:5]
archsp <- archspirals[1:5]
out <- two_sample_functional_test(tref1, archsp, B = 10L, scale_size = 20L)
plot(out$iwt, xrange = range(out$scale_seq))
matplot(
  out$scale_seq[-1],
  t(rbind(out$xfd, out$yfd)),
  type = "l",
  col = c(rep(1, length(tref1)), rep(2, length(archsp)))
)
}
\references{
Pini, A., & Vantini, S. (2017). Interval-wise testing for functional data. Journal of Nonparametric Statistics, 29(2), 407-424.
}
