% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insulin.secretion-package.R
\docType{package}
\name{insulin.secretion-package}
\alias{insulin.secretion}
\alias{insulin.secretion-package}
\title{insulin.secretion: Insulin Secretion Rate Deconvolution}
\description{
Calculates insulin secretion rates from C-peptide values based on the methods described in Van Cauter et al. (1992) \doi{10.2337/diab.41.3.368}. Includes functions to calculate estimated insulin secretion rates using linear or cubic spline interpolation of c-peptide values (see Eaton et al., 1980 \doi{10.1210/jcem-51-3-520} and Polonsky et al., 1986 \doi{10.1172/JCI112308}) and to calculate estimates of input coefficients (volume of distribution, short half life, long half life, and fraction attributed to short half life) as described by Van Cauter. Although the generated coefficients are specific to insulin secretion, the two-compartment secretion model used here is useful for certain applications beyond insulin.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kstier/isr.deconv}
  \item Report bugs at \url{https://github.com/kstier/isr.deconv/issues}
}

}
\author{
\strong{Maintainer}: Ken Stier \email{kennethstier99@gmail.com} [copyright holder]

}
\keyword{internal}
