% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionGraphs.R
\name{interactionGraph}
\alias{interactionGraph}
\title{Creates Interaction graph}
\usage{
interactionGraph(df, classAtt, intNo = 16, speedUp = FALSE)
}
\arguments{
\item{df}{A \code{discrete} \code{data.frame}}

\item{classAtt}{A class column of the df (\code{string})}

\item{intNo}{A desired number of interactions to show, i.e. an
(\code{integer}) in range: [2,20]; Default value is 16.}

\item{speedUp}{A (\code{boolean}) parameter. If \code{TRUE}, indicates
whether the pairs of attributes with Information Gain equal to zero (on the
4th decimal) should be pruned. This speeds up calculations for larger
datasets. By default it is turned off (i.e. set to \code{FALSE}).}
}
\value{
An interaction graph object (\code{string})
}
\description{
Creates Interaction graph
}
\examples{
interactionGraph(golf, "Play", intNo = 10)
\donttest{interactionGraph(golf, "Play", intNo = 10, speedUp = FALSE)}
\donttest{interactionGraph(golf, "Play", intNo = 10, speedUp = TRUE)}
}
