% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_consensus.R
\name{extract_consensus}
\alias{extract_consensus}
\title{Extract consensus intervals from ICM Stan Fit Object}
\usage{
extract_consensus(icm_stanfit, print_summary = TRUE)
}
\arguments{
\item{icm_stanfit}{An object of class \code{icm_stanfit} containing the fitted
Stan model.}

\item{print_summary}{A logical value indicating whether to print a summary
of the extracted parameters. Default is \code{TRUE}.}
}
\value{
A list containing:
\item{df_rvar}{A data frame with extracted posterior samples in the random
variable datatype (see \code{\link[posterior:rvar]{posterior::rvar()}}).}
\item{summary}{A table with posterior medians and credible intervals for the
consensus intervals.}
}
\description{
This function extracts parameter estimates for the consensus intervals from a
fitted Interval Consensus Model Stan fit object of class \code{icm_stanfit}.
}
\details{
This function extracts parameter estimates for the consensus intervals from a
fitted Interval Consensus Model Stan fit object of class \code{icm_stanfit}.
}
\examples{
\donttest{
# Create minimal example data
df_simplex <- data.frame(
  x1 = c(0.3, 0.4, 0.2, 0.5),
  x2 = c(0.3, 0.2, 0.4, 0.2),
  x3 = c(0.4, 0.4, 0.4, 0.3)
)
id_person <- c(1, 1, 2, 2)
id_item <- c(1, 2, 1, 2)

# Fit ICM model
fit <- fit_icm(df_simplex, id_person, id_item, n_chains = 1,
               iter_sampling = 100, iter_warmup = 100,
               refresh = 0)

# Extract consensus intervals
consensus <- extract_consensus(fit)
}

}
