% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{splx_to_itvl}
\alias{splx_to_itvl}
\title{Convert from simplex to interval bounds}
\usage{
splx_to_itvl(simplex, min = NULL, max = NULL)
}
\arguments{
\item{simplex}{A numeric vector that is a 2-simplex (3 elements that sum to 1)
or a data frame where each of the rows is a 2-simplex.}

\item{min}{Minimum of the original response scale.}

\item{max}{Maximum of the original response scale.}
}
\value{
A numeric vector with 2 elements representing the lower and upper
bounds of the interval response, or a data frame where each of the rows
contains such a vector.
}
\description{
Convert from simplex/compostional format to interval bounds
format. See also \code{\link[=itvl_to_splx]{itvl_to_splx()}} for the inverse transformation.
}
\examples{
responses <- data.frame(rbind(c(.1,.5,.4), c(.3,.4,.3)))
splx_to_itvl(responses, min = 0, max = 1)


}
\seealso{
\code{\link[=itvl_to_splx]{itvl_to_splx()}}
}
