% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{.solveWtExp}
\alias{.solveWtExp}
\title{Correlation between weighted predictor composite and criterion.}
\usage{
.solveWtExp(wt, rxx, rxy_list)
}
\arguments{
\item{wt}{A vector of predictor weights, or a matrix of predictor weights with
one column per predictor and one row per case.}

\item{rxx}{A matrix of predictor intercorrelations.}

\item{rxy_list}{A list of rxy vectors.}
}
\value{
A matrix of correlation coefficent with one row per weight vector
        and one column per rxy vector.
}
\description{
Correlation between weighted predictor composite and criterion.
}
\note{
This function should be merged with the fuse functions and replace the
      other .solvewt functions.
}
\examples{
library(iopsych)
data(dls2007)
dat <- dls2007[1:6, 2:7]
rxx <- dat[1:4, 1:4]
rxy1 <- dat[1:4, 5]
rxy2 <- dat[1:4, 6]
rxy_list <- list(rxy1, rxy2)

wt1 <- c(1,1,1,1)
wt2 <- c(1,2,3,4)
wt_mat <- rbind(wt1, wt2)

#.solveWtExp(wt=wt_mat, rxx=rxx, rxy_list=rxy_list)
}
\author{
Allen Goebl Jeff Jones
}
\keyword{internal}

