% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_importance.R
\name{relWt}
\alias{relWt}
\title{Relative weights}
\usage{
relWt(r_mat, y_col, x_col)
}
\arguments{
\item{r_mat}{A correlation matrix.}

\item{y_col}{A vector of columns representing criterion variables.}

\item{x_col}{A vector of columns representing predictor variables.}
}
\value{
A list containing the objects eps, beta_star, and lambda_star. The object eps contains 
         the vector of relative weights of the predictors whose sum is equivalent to the model \eqn{R^2}
         (see Johnson, 2000, ps 8 - 9). The object beta_star contains the regression weights from
         regressing the criterion on Z, the 'best fitting orthogonal approximation' of the predictor 
         variables (see Johnson, 2000, p. 5). The object lambda_star contains the regression coefficients 
         from regressing Z on the predictor variables (see Jonhson, 2000, p. 8).
}
\description{
Function to implement Johnson's (2000) relative weight computation.
}
\examples{
Rs <- matrix(c(1.0, 0.2,  0.3, 0.4, -0.4,
               0.2, 1.0,  0.5, 0.1,  0.1,
               0.3, 0.5,  1.0, 0.2, -0.3,
               0.4, 0.1,  0.2, 1.0,  0.4,
              -0.4, 0.1, -0.3, 0.4,  1.0), 5, 5)
ys <- 5
xs <- 1:4

relWt(Rs, ys, xs)
}
\author{
Jeff Jones and Allen Goebl
}
\references{
Johnson, J. (2000). A heuristic method for estimating the
            relative weight of predictor variables in multiple regression.
            \emph{Multivariate Behavioral Research, 35}, 1--19.
}

