% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{utilityB}
\alias{utilityB}
\title{Boudreau Utility Model.}
\usage{
utilityB(n = 1, sdy, rxy = NULL, uxs = NULL, sr = NULL, pux = NULL,
  cost = 0, period = 1, v = 0, tax = 0, i = 0)
}
\arguments{
\item{n}{The size of the applicant pool}

\item{sdy}{The standard deviation of performance in monetary units.}

\item{rxy}{the correlation between the predictor composite and the criterion.}

\item{uxs}{The average predicter score of those selected. If the uxs is 
unknown, the sr argument can used instead.}

\item{sr}{A selection ratio or a vector of selection ratios.}

\item{pux}{The expected average criterion score of selected applicants.}

\item{cost}{The cost per applicant of a selection system.}

\item{period}{The anticipated tenure of selected employees.}

\item{v}{The proportion of new costs to new revenue (i.e. sc/sv).}

\item{tax}{The marginal tax rate.}

\item{i}{Discount rate.}
}
\value{
Estimated gain in utility.
}
\description{
This utility model extends the BCG model with additional financial variables.
}
\note{
This functions can except either (1) pux, (2) uxs and rxy, or (3) sr and rxy.
}
\examples{
utilityB(sdy=10000, rxy=.50, sr=.30, period=4, v=.5, tax=.1, i=.02)
}
\author{
Allen Goebl and Jeff Jones
}
\references{
Boudreau, J.W. (1983). Economic considerations in estimating
  the utility of human resource productivity improvement programs. 
  \emph{Personnel Psychology}, 36, 551-576.
}

