% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{utilityRbn}
\alias{utilityRbn}
\title{Raju-Burke-Normand Utility Model}
\usage{
utilityRbn(n = 1, sdr, a, rxy, uxs = NULL, sr = NULL, pux = NULL,
  cost = 0, period = 1)
}
\arguments{
\item{n}{The size of the applicant pool.}

\item{sdr}{The standard deviation of ratings of job performance.}

\item{a}{The average total compensation.}

\item{rxy}{The correlation between the predictor composite and the criterion.}

\item{uxs}{The average predicter score of those selected. If the uxs is 
unknown, the sr argument can used instead.}

\item{sr}{A selection ratio or a vector of selection ratios.}

\item{pux}{The expected average criterion score of selected applicants.}

\item{cost}{The cost per applicant of a selection system.}

\item{period}{The anticipated tenure of selected employees.}
}
\value{
Estimated gain in utility.
}
\description{
This utility model uses SD of job performance ratings rather than the SD of
job performance in monetary units.
}
\note{
This functions can except either (1) pux, (2) uxs and rxy, or (3) sr and rxy.
}
\examples{
utilityRbn(sdr=10000, a=90000, rxy=.50, sr=.30)
}
\author{
Allen Goebl and Jeff Jones
}
\references{
Raju, N.S., Burke, M.J. and Normand, J. (1990). A new approach
for utility analysis. \emph{Journal of Applied Psychology}, 75, 3-12.
}

