% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_matrix_create.R
\name{coefficient_matrix_create}
\alias{coefficient_matrix_create}
\title{Create a coefficient matrix}
\usage{
coefficient_matrix_create(
  data_table,
  total = "output",
  digits = NULL,
  remove_empty = TRUE,
  households = FALSE,
  return_part = NULL,
  ...
)
}
\arguments{
\item{data_table}{A symmetric input–output table, use table, margins or
tax table retrieved by \code{\link[=iotable_get]{iotable_get()}}.}

\item{total}{Character. Row label to use as denominator. Defaults to
\code{"output"}. Accepts \code{"P1"}, \code{"output_bp"}, \code{"total"}, \code{"cpa_total"}.}

\item{digits}{Optional integer. Number of digits for rounding. Default
\code{NULL} (no rounding).}

\item{remove_empty}{Logical. Defaults to \code{TRUE}. If \code{FALSE}, empty
primary-input rows are kept. Empty product/industry rows are always
removed.}

\item{households}{Logical. If \code{TRUE}, include household column. Default
\code{FALSE}.}

\item{return_part}{Optional. \code{"products"}, \code{"industries"}, or
\code{"primary_inputs"} to select a subset of the matrix. Default \code{NULL}
returns the full matrix.}

\item{...}{Optional extra arguments for future extensions, ignored by
default.}
}
\value{
A data.frame with:
\itemize{
\item The key column from \code{data_table}
\item Numeric columns containing input coefficients
}
}
\description{
Compute a coefficient matrix from a symmetric input–output table (SIOT),
use table, or similar. By default, coefficients are related to output,
but you can use other totals if present.
}
\details{
The coefficient matrix \eqn{A} is formed by dividing each row of the
inter-industry flows by an output or supply total. By default, the
denominator is \code{"output"} (equivalent to \code{"P1"} or \code{"output_bp"}).
Alternative totals can be supplied via the \code{total} argument.
}
\examples{
cm <- coefficient_matrix_create(
  data_table = iotable_get(source = "germany_1995"),
  total = "output",
  digits = 4
)

}
\seealso{
Other indicator functions: 
\code{\link{direct_effects_create}()},
\code{\link{input_indicator_create}()}
}
\concept{indicator functions}
