% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conforming_vector_create.R
\name{conforming_vector_create}
\alias{conforming_vector_create}
\title{Create an Empty Conforming Vector}
\usage{
conforming_vector_create(data_table)
}
\arguments{
\item{data_table}{A use table, coefficient matrix, Leontief matrix, or other
named matrix or data frame.}
}
\value{
A one-row \code{data.frame} with the same column names as \code{data_table},
but with all values set to zero.
}
\description{
Create a named vector (in wide format) that conforms to the structure of a
given analytical object, such as a use table, coefficient matrix, or
Leontief matrix. This helps avoid mistakes when manually defining large
vectors (e.g., for 60 × 60 matrices).
}
\details{
The empty conforming vector can also be exported to \code{.csv} format and used
as a template for importing scenarios from a spreadsheet application.
}
\examples{
de_input_flow <- input_flow_get(data_table = iotable_get())
conforming_vector_create(de_input_flow)

}
\seealso{
Other iotables processing functions: 
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
