% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{vector_transpose_wider}
\alias{vector_transpose_wider}
\title{Transpose a Vector to Wide Form}
\usage{
vector_transpose_wider(
  data_table,
  names_from,
  values_from,
  key_column_name = NULL,
  key_column_values = NULL
)
}
\arguments{
\item{data_table}{A \code{data.frame} or tibble, normally with a key column.
If the key column must be created or replaced, use \code{key_column_name} and
\code{key_column_values}.}

\item{names_from, values_from}{Columns specifying the names of the output
columns (\code{names_from}) and the values to fill (\code{values_from}).}

\item{key_column_name}{The name of the key column.}

\item{key_column_values}{Optional explicit key column values. Default:
\code{NULL}, in which case values are inferred from the long data.}
}
\description{
Convert a long-form vector (e.g., indicators, multipliers) into wide form,
which is often more useful for binding with input–output tables. This is a
thin wrapper around \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}, provided so you do not need to
load \strong{tidyr} explicitly.
}
\examples{
vector_transpose_wider(
  data_table = germany_airpol[, -2],
  names_from = "induse",
  values_from = "value"
)

vector_transpose_wider(
  data_table = germany_airpol[1:8, 3:4],
  names_from = "induse",
  values_from = "value",
  key_column_values = "CO2_emission"
)
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()}
}
\concept{iotables processing functions}
