% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async-progress.R
\name{AsyncProgress}
\alias{AsyncProgress}
\title{A progress bar object where inc and set are usable within other processes}
\description{
A progress bar object where inc and set are usable within other processes

A progress bar object where inc and set are usable within other processes
}
\details{
An async compatible wrapper around Shiny's progress bar. It should be instatiated
from the main process, but may be closed, set and incremented from any process.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(future)
plan(multisession)
ui <- fluidPage(
  actionButton("run","Run"),
  tableOutput("dataset")
)

server <- function(input, output, session) {

  dat <- reactiveVal()
  observeEvent(input$run, {
    progress <- AsyncProgress$new(session, min=1, max=15)
    future({
      for (i in 1:15) {
        progress$set(value = i)
        Sys.sleep(0.5)
      }
      progress$close()
      cars
    }) \%...>\% dat
    NULL #return something other than the future so the UI is not blocked
  })

  output$dataset <- renderTable({
    req(dat())
  })
}

shinyApp(ui, server)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AsyncProgress-new}{\code{AsyncProgress$new()}}
\item \href{#method-AsyncProgress-getMax}{\code{AsyncProgress$getMax()}}
\item \href{#method-AsyncProgress-getMin}{\code{AsyncProgress$getMin()}}
\item \href{#method-AsyncProgress-sequentialClose}{\code{AsyncProgress$sequentialClose()}}
\item \href{#method-AsyncProgress-set}{\code{AsyncProgress$set()}}
\item \href{#method-AsyncProgress-inc}{\code{AsyncProgress$inc()}}
\item \href{#method-AsyncProgress-close}{\code{AsyncProgress$close()}}
\item \href{#method-AsyncProgress-clone}{\code{AsyncProgress$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-new"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-new}{}}}
\subsection{Method \code{new()}}{
Creates a new progress panel and displays it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$new(
  ...,
  queue = shinyQueue(),
  millis = 250,
  value = NULL,
  message = NULL,
  detail = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional parameters to be passed to Shiny::Progress}

\item{\code{queue}}{A Queue object for message passing}

\item{\code{millis}}{How often in milliseconds should updates to the progress bar be checked for.}

\item{\code{value}}{A numeric value at which to set
the progress bar, relative to \code{min} and \code{max}.}

\item{\code{message}}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message
(if any).}

\item{\code{detail}}{A single-element character vector; the detail message
to be displayed to the user, or \code{NULL} to hide the current
detail message (if any). The detail message will be shown with a
de-emphasized appearance relative to \code{message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-getMax"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-getMax}{}}}
\subsection{Method \code{getMax()}}{
Returns the maximum
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$getMax()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-getMin"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-getMin}{}}}
\subsection{Method \code{getMin()}}{
Returns the minimum
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$getMin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-sequentialClose"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-sequentialClose}{}}}
\subsection{Method \code{sequentialClose()}}{
Removes the progress panel and destroys the queue. Must be called from main process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$sequentialClose()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-set"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-set}{}}}
\subsection{Method \code{set()}}{
Updates the progress panel. When called the first time, the
      progress panel is displayed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$set(value = NULL, message = NULL, detail = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A numeric value at which to set}

\item{\code{message}}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message
(if any).}

\item{\code{detail}}{A single-element character vector; the detail message
to be displayed to the user, or \code{NULL} to hide the current
detail message (if any). The detail message will be shown with a
de-emphasized appearance relative to \code{message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-inc"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-inc}{}}}
\subsection{Method \code{inc()}}{
Like \code{set}, this updates the progress panel. The difference is
      that \code{inc} increases the progress bar by \code{amount}, instead
      of setting it to a specific value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$inc(amount = 0.1, message = NULL, detail = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{amount}}{the size of the increment.}

\item{\code{message}}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message
(if any).}

\item{\code{detail}}{A single-element character vector; the detail message
to be displayed to the user, or \code{NULL} to hide the current
detail message (if any). The detail message will be shown with a
de-emphasized appearance relative to \code{message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-close"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-close}{}}}
\subsection{Method \code{close()}}{
Fires a close signal and may be used from any process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncProgress-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncProgress-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncProgress$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
