% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.ipmr_matrix}
\alias{plot.ipmr_matrix}
\alias{plot.simple_di_det_ipm}
\alias{plot.simple_di_stoch_param_ipm}
\alias{plot.simple_di_stoch_kern_ipm}
\alias{plot.general_di_det_ipm}
\title{Plot a matrix or an *_ipm object}
\usage{
\method{plot}{ipmr_matrix}(
  x = NULL,
  y = NULL,
  A,
  col = grDevices::rainbow(100, start = 0.67, end = 0),
  bw = FALSE,
  do_contour = FALSE,
  do_legend = FALSE,
  contour_cex = 1,
  ...
)

\method{plot}{simple_di_det_ipm}(
  x = NULL,
  y = NULL,
  ipm = NULL,
  col = rainbow(100, start = 0.67, end = 0),
  bw = FALSE,
  do_contour = FALSE,
  do_legend = FALSE,
  exponent = 1,
  n_row = 1,
  n_col = 1,
  ...
)

\method{plot}{simple_di_stoch_param_ipm}(
  x = NULL,
  y = NULL,
  ipm = NULL,
  col = rainbow(100, start = 0.67, end = 0),
  bw = FALSE,
  do_contour = FALSE,
  do_legend = FALSE,
  exponent = 1,
  n_row = 1,
  n_col = 1,
  ...
)

\method{plot}{simple_di_stoch_kern_ipm}(
  x = NULL,
  y = NULL,
  ipm = NULL,
  col = rainbow(100, start = 0.67, end = 0),
  bw = FALSE,
  do_contour = FALSE,
  do_legend = FALSE,
  exponent = 1,
  n_row = 1,
  n_col = 1,
  ...
)

\method{plot}{general_di_det_ipm}(
  x = NULL,
  y = NULL,
  ipm = NULL,
  mega_mat = NA_character_,
  col = rainbow(100, start = 0.67, end = 0),
  bw = FALSE,
  do_contour = FALSE,
  do_legend = FALSE,
  exponent = 1,
  n_row = 1,
  n_col = 1,
  ...
)
}
\arguments{
\item{x, y}{Either the values of the meshpoints or \code{NULL}. If \code{NULL},
then a sequence is generated so that meshpoints are given sequential bin numbers.}

\item{A, ipm}{A matrix or a result from \code{make_ipm}, or \code{NULL} if \code{x}
is specified as the matrix or IPM object.}

\item{col}{A vector of colors to use for plotting}

\item{bw}{A logical indicating whether to use a greyscale palette for plotting}

\item{do_contour}{A logical indicating whether or not draw contour lines
on the plot}

\item{do_legend}{A logical indicating whether to draw a legend for the plot}

\item{contour_cex}{A numeric specifying how large to make labels for the
contour lines.}

\item{...}{further arguments passed to legend}

\item{exponent}{The exponent to raise each kernel to. Setting this to a low
number can help visualize kernels that are overwhelmed by a few very large
numbers.}

\item{n_row, n_col}{If plotting multiple (sub-)kernels, how many rows and
columns to arrange them in.}

\item{mega_mat}{A vector with symbols, I's, and/or 0s representing the matrix blocks.
They should be specified in ROW MAJOR order! Can also be a character
string specifying the call. Parameter set index syntax is supported. When used,
\code{format_mega_kernel} will produce as many mega-matrices as there are
combinations of \code{par_set_indices} in the \code{proto_ipm}.}
}
\value{
\code{A} or \code{ipm} invisibly
}
\description{
Plot a matrix or an *_ipm object
}
\details{
If an IPM kernel is overwhelmed by information in say, a fecundity sub-kernel,
use the \code{exponent} argument in \code{plot.*_ipm} to make it more visually
appealing.
}
