% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot.ipriorMod}
\alias{plot.ipriorMod}
\alias{plot_resid}
\alias{plot_fitted_multilevel}
\alias{plot_fitted}
\alias{plot_iter}
\alias{plot_ppc}
\title{Plots for I-prior models}
\usage{
\method{plot}{ipriorMod}(x, ...)

plot_resid(x)

plot_fitted_multilevel(
  x,
  X.var = 1,
  grp.var = 1,
  facet = c(2, 3),
  cred.bands = TRUE,
  show.legend = TRUE,
  show.points = TRUE,
  x.lab = NULL,
  y.lab = NULL,
  grp.lab = NULL,
  extrapolate = FALSE
)

plot_fitted(x, X.var = 1, cred.bands = TRUE, size = 1, linetype = "solid")

plot_iter(x, niter.plot = NULL, lab.pos = c("up", "down"))

plot_ppc(x, draws = 100)
}
\arguments{
\item{x}{An \code{ipriorMod} object.}

\item{...}{Not used}

\item{X.var}{The index of the X variable to plot.}

\item{grp.var}{Index of the grouping variable for multilevel plots.}

\item{facet}{The index of the X variable in which to facet. This is a vector
of maximum length 2.}

\item{cred.bands}{Logical. Plot the confidence intervals? Defaults to
\code{TRUE}.}

\item{show.legend}{Logical. Show legend?}

\item{show.points}{Logical. Show data points?}

\item{x.lab}{(Optional) X axis label.}

\item{y.lab}{(Optional) Y axis label.}

\item{grp.lab}{(Optional) The name for the groups, which is also the legend
title.}

\item{extrapolate}{Logical. Extend the fitted regression line to fill the
plot?}

\item{size}{Size of the fitted line}

\item{linetype}{Type of the fitted line}

\item{niter.plot}{(Optional) Vector of length at most two, indicating the
start and end points of the iterations to plot.}

\item{lab.pos}{Adjust the position of the log-likelihood label.}

\item{draws}{Number of draws for posterior predictive check.}

\item{grp}{The index of the groups.}
}
\description{
There are three types of plots that are currently written in the package:
\describe{ \item{\code{plot_fitted}}{Plot the fitted regression line with
credibility bands.} \item{\code{plot_predict}}{Plot residuals against fitted
values.} \item{\code{plot_iter}}{Plot the progression of the log-likelihood
value over time.} } The S3 method \code{plot} for class \code{ipriorMod}
currently returns \code{plot_fitted}.
}
\details{
See ggplot2 documentation for the plotting parameters.
}
