% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{unite.ir}
\alias{unite.ir}
\title{Unite multiple columns in an \code{ir} object into one by pasting strings together}
\source{
\code{\link[tidyr:unite]{tidyr::unite()}}
}
\usage{
unite.ir(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{An object of class \code{ir}.}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\value{
\code{.data} with united columns. If the \code{spectra} column is
dropped or invalidated (see \code{\link[=ir_new_ir]{ir_new_ir()}}), the \code{ir} class is dropped, else
the object is of class \code{ir}.
}
\description{
Unite multiple columns in an \code{ir} object into one by pasting strings together
}
\examples{
## unite
ir_sample_data |>
  tidyr::separate(
    "id_sample",  c("a", "b", "c")
  ) |>
  tidyr::unite(id_sample, a, b, c)


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate}},
\code{\link{mutate-joins}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}}
}
\concept{tidyverse}
