% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_ndvi}
\alias{scale_ndvi}
\title{Scale NDVI}
\usage{
scale_ndvi(DT)
}
\arguments{
\item{DT}{data.table of NDVI time series}
}
\value{
data.table with appended 'scaled' column of 0-1 scaled NDVI.
}
\description{
Using filtered NDVI time series, scale it to 0-1.
}
\details{
This functions expects the input \code{DT} is the output of previous four filtering steps, or \code{filter_ndvi}.
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

# Filter and scale NDVI time series
filter_ndvi(ndvi)
scale_ndvi(ndvi)
}
\seealso{
Other scale: 
\code{\link{scale_doy}()}
}
\concept{scale}
