% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree.coeff2.r
\name{kappa2.table}
\alias{kappa2.table}
\title{Kappa coefficient for 2 raters}
\usage{
kappa2.table(ratings, weights = identity.weights(1:ncol(ratings)),
  conflev = 0.95, N = Inf)
}
\arguments{
\item{ratings}{A square or contingency table of ratings (assume no missing ratings). See the 2 datasets 
"cont3x3abstractors" and "cont4x4diagnosis" that come with this package as examples.}

\item{weights}{An optional matrix that contains the weights used in the weighted analysis.}

\item{conflev}{An optional confidence level for confidence intervals. The default value is the traditional 0.95.}

\item{N}{An optional population size.  The default value is infinity.}
}
\value{
A data frame containing the following 5 variables: coeff.name coeff.val coeff.se coeff.ci coeff.pval.
}
\description{
Kappa coefficient for 2 raters
}
\examples{
#The dataset "cont3x3abstractors" comes with this package. Analyze it as follows:
kappa2.table(cont3x3abstractors) #Yields Cohen's kappa along with precision measures
kappa <- kappa2.table(cont3x3abstractors)$coeff.val #Yields Cohen's kappa alone.
kappa
q <- nrow(cont3x3abstractors) #Number of categories
kappa2.table(cont3x3abstractors,weights = quadratic.weights(1:q))#weighted kappa/quadratic wts
}
