% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{pval.ICC1a}
\alias{pval.ICC1a}
\title{P-value of the ICC under ANOVA Model 1A for the specific null values 0,0.1,0.3,0.5,0.7,0.9.}
\usage{
pval.ICC1a(ratings)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}
}
\value{
This function returns a vector containing 6 p-values associated with the 6 null values 0,0.1,0.3,0.5,0.7,0.9.
}
\description{
This function computes the p-value associated with the Intraclass Correlation Coefficient (ICC) under the one-factor ANOVA
model where each subject may be rated by a different group of raters.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
pval.ICC1a(iccdata1)
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 8, section 8.3.2, equation
8.3.4. Advanced Analytics, LLC.
}
