% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_parse_csv.R
\name{isd_parse_csv}
\alias{isd_parse_csv}
\title{Parse NOAA ISD/ISH csv data files}
\usage{
isd_parse_csv(path)
}
\arguments{
\item{path}{(character) file path. required}
}
\value{
A tibble (data.frame)
}
\description{
Parse NOAA ISD/ISH csv data files
}
\details{
Note that the `rem` (remarks) and `eqd` columns are
not parsed, just as with [isd_parse()].
}
\section{Column information}{


- USAF MASTER and NCEI WBAN station identifiers are combined into an 11
character code with the column `station`
- Date and Time have been combined to the column `date`
- Call letter is synonymous with `call_sign` column
- WIND-OBSERVATION is abbreviated as column `wnd`
- SKY-CONDITION-OBSERVATION is abbreviated as column `cig`
- VISIBILITY-OBSERVATION is abbreviated as column `vis`
- AIR-TEMPERATURE-OBSERVATION air temperature is abbreviated as the column
header `tmp`
- AIR-TEMPERATURE-OBSERVATION dew point is abbreviated as the column
`dew`
- AIR-PRESSURE-OBSERVATION sea level pressure is abbreviated as the column
`slp`
}

\examples{
path <- system.file('extdata/00702699999.csv', package = "isdparser")
(res <- isd_parse_csv(path))

# isd_parse_csv compared to isd_parse
if (interactive()) {
x="https://www.ncei.noaa.gov/data/global-hourly/access/2017/00702699999.csv"
download.file(x, (f_csv=file.path(tempdir(), "00702699999.csv")))
y="ftp://ftp.ncdc.noaa.gov/pub/data/noaa/2017/007026-99999-2017.gz"
download.file(y, (f_gz=file.path(tempdir(), "007026-99999-2017.gz")))
from_csv <- isd_parse_csv(f_csv)
from_gz <- isd_parse(f_gz, parallel = TRUE)

x="https://www.ncei.noaa.gov/data/global-hourly/access/1913/02982099999.csv"
download.file(x, (f=file.path(tempdir(), "02982099999.csv")))
isd_parse_csv(f)

x="https://www.ncei.noaa.gov/data/global-hourly/access/1923/02970099999.csv"
download.file(x, (f=file.path(tempdir(), "02970099999.csv")))
isd_parse_csv(f)

x="https://www.ncei.noaa.gov/data/global-hourly/access/1945/04390099999.csv"
download.file(x, (f=file.path(tempdir(), "04390099999.csv")))
isd_parse_csv(f)

x="https://www.ncei.noaa.gov/data/global-hourly/access/1976/02836099999.csv"
download.file(x, (f=file.path(tempdir(), "02836099999.csv")))
isd_parse_csv(f)
}
}
\references{
https://www.ncei.noaa.gov/data/global-hourly/access/
https://www.ncei.noaa.gov/data/global-hourly/doc/CSV_HELP.pdf
https://www.ncei.noaa.gov/data/global-hourly/doc/isd-format-document.pdf
}
