% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatesToProbabilities.R
\name{cetotrans}
\alias{cetotrans}
\title{From rates to probabilities}
\usage{
cetotrans(c, e, dt = 1)
}
\arguments{
\item{c}{Colonization rate.}

\item{e}{Extinction rate.}

\item{dt}{Interval of time or a vector of time intervals.}
}
\value{
A matrix with the transition probabilities \eqn{T_{01}} and \eqn{T_{10}} of the Markov chain
  associated with the specified colonization and extinction rates.
}
\description{
\code{cetotrans} calculates transition probabilities from colonization and
extinction rates for a determined interval of time, when provided.
}
\details{
Given a pair of colonization and extinction rates, we can calculate
  the transition probabilities with the following equations: \deqn{T_{01} = (e
  / (c + e)) * (1 - exp( - (c + e) * dt))} \deqn{T_{10} = (c / (c + e)) * (1 -
  exp( - (c + e) * dt))}
}
\examples{
cetotrans(0.13, 0.19)
cetotrans(0.2, 0.2, 2)
}
