% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{coord_align}
\alias{coord_align}
\title{Align the object with the given coordinates}
\usage{
coord_align(coords, loc = c(0, 0, 0), x = "mean", y = "mean", z = "mean")
}
\arguments{
\item{coords}{data.frame with 'x', 'y' and 'z' coordinates}

\item{loc}{location to align to.  Default: c(0, 0, 0)}

\item{x, y, z}{how to align the x coordinates to the given location.
Default: 'mean'.  Valid values 'min', 'mean', 'max', 'identity', 'median'}
}
\value{
data.frame of transformed coordinates
}
\description{
Align the object with the given coordinates
}
\examples{
gen_sphere() |>
   coord_align(z = 'max', y = 'min') |>
   isocubesGrob(size = 3) |>
   grid::grid.draw()
}
