% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialOrders.R
\name{compOrd}
\alias{compOrd}
\title{Componentwise partial order relation}
\usage{
compOrd(X)
}
\arguments{
\item{X}{a numeric matrix or a data frame containing numeric or ordered
factor variables with at least two columns.}
}
\value{
A list containing

\item{\code{paths}}{a two-column matrix giving all pairs of indices
  \code{(i,j)} which satisfy \code{all(X[i, ] <= X[j, ])}.}

\item{\code{colOrder}}{a matrix of the columnwise orders of \code{X}. Used to
  compute paths and required for other function calls.}
}
\description{
Compares all rows of a numeric matrix or data frame \code{X}
with respect to the componentwise order. A row \code{X[i, ]} is smaller or
equal to a row \code{X[j, ]} in the componentwise order, if \code{X[i, k] <=
X[j, k]} for \code{k = 1, ..., ncol(X)}.
}
\details{
The columns of \code{X} are sorted sequentially: First all constraints
based on only the first column \code{X[, 1]} are activated (set \code{TRUE}),
then constraints are dropped based on the orders of the remaining columns.
This avoids \code{nrow(X)^2 / 2} pairwise comparisons.
}
\keyword{internal}
