% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dindexm.R
\name{predict.dindexfit}
\alias{predict.dindexfit}
\title{Predict method for distributional index model (DIM)}
\usage{
\method{predict}{dindexfit}(
  object,
  data = NULL,
  digits = 3,
  interpolation = "linear",
  asplitAvail = TRUE,
  ...
)
}
\arguments{
\item{object}{DIM fit (object of class \code{"dindexfit"}).}

\item{data}{optional \code{data.frame} containing variables with which to
predict. In-sample predictions are returned if this is omitted.}

\item{digits}{number of decimal places for the predictive CDF.}

\item{interpolation}{interpolation method for univariate index Default is 
\code{"linear"}. Any other argument will select midpoint interpolation (see 
'Details' in \code{\link{predict.idrfit}}). Has no effect for multivariate
index function.}

\item{asplitAvail}{use \code{\link[base]{asplit}} for splitting arrays
(default is \code{TRUE}). Set to \code{FALSE} for R Versions < 3.6, where
\code{asplit} is not available.}

\item{...}{further arguments passed to the index prediction function.}
}
\value{
A list of predictions, as for \code{\link{predict.idrfit}}.
}
\description{
Prediction based on distributional index model fit.
}
\seealso{
Examples in \code{\link{dindexm}}.
}
