% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_functions.R
\name{orbi_calculate_ions}
\alias{orbi_calculate_ions}
\title{Calculate ions from intensities}
\usage{
orbi_calculate_ions(dataset, CN = 3, RN = 240000)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{CN}{noise factor}

\item{RN}{reference resolution of the noise factor}
}
\value{
same object as provided in \code{dataset} with new column \code{ions.incremental}
}
\description{
This functions calculates ions (\code{ions.incremental}) from intensities based on the equation \deqn{N_{ions} = S/N \cdot{} C_N/z \cdot{} \sqrt{R_N/R} \cdot \sqrt{N_{MS}}}
where S is the reported signal (\code{intensity}) of the isotopocule, N is the noise associated with the signal (\code{peakNoise}),
measured at the resolution setting R (\code{resolution}), the noise factor \eqn{C_N} (\code{CN}) is the number of charges corresponding to the Orbitrap noise band
at some reference resolution \eqn{R_N} (\code{RN}), \eqn{N_{MS}} is the number of microscans, and z is the charge per ion (\code{charge}) of the isotopocule.
See Makarov and Denisov (2009) and Eiler et al. (2017) for details about this equation. The default values for \code{CN} and \code{RN} are from the
Orbitrap Exploris Isotope Solutions Getting Started Guide (BRE0032999, Revision A, October 2022). Note that the exact values of these factors are
only critical if the number of ions are interpreted outside of ratio calculations (in ratio calculations, these factors cancel).
}
\details{
If using a dataset read from isox files you might have to add a \code{charge} column if it does not yet exist that indicates the charge of the isotopocule.
If using data from raw files, \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} will automatically call this function with the default \code{CN} and \code{RN} so you don't need to
call it explicitly unless you want to change these parameters.
}
